<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Ufficio Catastale</title>
<?php require_once('includes/inc-css.php'); ?>
</head>

<body>
<?php require_once('includes/inc-header.php'); ?>
<main id="content" role="main">
<?php require_once('includes/inc-breadcrumbs.php'); ?>
  <div class="container mt-5 content-space-b-1">
    <div class="row">
      <div class="col-lg-8">
        <h1 class="mb-2 h4 "><span class="fw-light">Codice Fiscale:</span> DGCMTT80E17H501Z</h1>
        <div class="row">
          <div class="col-lg-12 mb-5">
            <ul class="list-group">
              <li class="list-group-item rounded-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. </li>
            </ul>
          </div>
        </div>
        <p class="h4 mt-4 mb-0 text-uppercase"><strong>OPZIONI DISPONIBILI</strong> </p>
        <div class="card bg-light">
          <div class="list-group p-3 bg-light">
            <label class="list-group-item border-0 bg-light">
            <input class="form-check-input me-1 " type="checkbox" value="">
            <a  data-bs-toggle="collapse" href="#collapse1" role="button" aria-expanded="false" aria-controls="collapse1" class="text-dark"> Stampa e invio per raccomandata urgente <strong>(+ € 7,80)</strong> </a>
            <div class="collapse" id="collapse1">
              <div class="card card-body">
                <div class="row">
                  <div class="col-lg-6 mb-3">
                    <div class="form-group">
                      <label for="destinatario_nome" >Nome*</label>
                      <input type="text" class="form-control form-control-sm " name="destinatario_nome" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-6 mb-3">
                    <div class="form-group">
                      <label for="destinatario_cognome" >Cognome*</label>
                      <input required="" type="text" class="form-control form-control-sm " name="destinatario_cognome" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-12 mb-3">
                    <div class="form-group">
                      <label for="destinatario_co" >Presso (c/o)</label>
                      <input type="text" class="form-control form-control-sm " name="destinatario_co" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-3 mb-3">
                    <div class="form-group">
                      <label for="destinatario_cap" >Cap*</label>
                      <input type="text" required="" class="form-control form-control-sm " name="destinatario_cap" placeholder="Cap" value="">
                    </div>
                  </div>
                  <div class="col-lg-9 mb-3">
                    <div class="form-group">
                      <label for="" >Comune</label>
                      <select class="form-select-sm form-select" name="destinatario_comune">
                        <option value="">-- Seleziona il Comune --</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-12 mb-3">
                    <div class="form-group">
                      <label for="" >Provincia</label>
                      <select class="form-select-sm form-select" name="destinatario_provincia">
                        <option value="">-- Seleziona la Provincia --</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-3 mb-3">
                    <div class="form-group">
                      <label for="" >Via/P.zza*</label>
                      <select required="" class="form-select-sm form-select" id="destinatario_dug" name="destinatario_dug" placeholder=" ">
                        <option value="Borgo">Borgo</option>
                        <option value="Campo">Campo</option>
                        <option value="CDA">Contrada</option>
                        <option value="Corso">Corso</option>
                        <option value="CRO">Crocevia</option>
                        <option value="FRZ">Frazione</option>
                        <option value="GAL">Galleria</option>
                        <option value="Largo">Largo</option>
                        <option value="LOC">Località</option>
                        <option value="PGA">Piaggia</option>
                        <option value="PZA">Piazza</option>
                        <option value="PLE">Piazzale</option>
                        <option value="PZL">Piazzale</option>
                        <option value="PTA">Piazzetta</option>
                        <option value="Rione">Rione</option>
                        <option value="SLT">Salita</option>
                        <option value="SZO">Spiazzo</option>
                        <option value="STR">Strada</option>
                        <option value="SST">Strada Statale</option>
                        <option value="TRV">Traversa</option>
                        <option selected="" value="Via">Via</option>
                        <option value="Viale">Viale</option>
                        <option value="VLO">Vicolo</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-7 mb-3">
                    <div class="form-group">
                      <label for="destinatario_indirizzo" >Indirizzo*</label>
                      <input required="" type="text" class="form-control form-control-sm " id="destinatario_indirizzo" name="destinatario_indirizzo" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-2 mb-3">
                    <div class="form-group">
                      <label for="destinatario_civico" >Civico*</label>
                      <input required="" type="text" class="form-control form-control-sm " id="destinatario_civico" name="destinatario_civico" placeholder=" " maxlength="5" value="">
                    </div>
                  </div>
                </div>
              </div>
            </div>
            </label>
            <label class="list-group-item border-0 bg-light">
            <input class="form-check-input me-1" type="checkbox" value="">
            <a  data-bs-toggle="collapse" href="#collapse2" role="button" aria-expanded="false" aria-controls="collapse2" class="text-dark">Avviso SMS a visura disponibile <strong>(+ € 0,50)</strong> </a>
            <div class="collapse " id="collapse2">
              <div class="card card-body">
                <div class="input-group mb-0"> <span class="input-group-text bg-light" id="basic-addon1">+39</span>
                  <input type="number" class="form-control form-control-sm" placeholder="Inserisci il tuo cellulare" aria-label="cellulare" aria-describedby="basic-addon1">
                </div>
              </div>
            </div>
            </label>
            <label class="list-group-item border-0 bg-light">
            <input class="form-check-input me-1" type="checkbox" value="">
            Urgenza <strong>(+ € 5,00)</strong>
            <ul style="font-size: 13px; " class="pt-2">
              <li>Visura Catastale per Immobile</li>
              <li>Planimetria Catastale</li>
              <li>Visura Ipotecaria per Immobile</li>
            </ul>
            </label>
          </div>
        </div>
        <div class="row justify-content-between mt-4 ">
          <div class="col-auto">
            <p class="h4 mb-0 text-uppercase"><strong>PRODOTTI  DISPONIBILI</strong> </p>
          </div>
        </div>
        <div class="row mb-5">
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox1" value="option1">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox1">Visura Catastale per Immobile</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 7,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox2" value="option2">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox2">Planimetria Catastale</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 12,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox3" value="option3">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox3">Visura Ipotecaria per Immobile</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 21,20 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
        </div>
        <div class="row mb-5">
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox4" value="option4">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox4">Visura Catastale Storica Persona Fisica</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 7,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> 2 ore</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox5" value="option5">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox5">Visura Catastale Storica Persona Giuridica</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 7,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> 24 ore</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                  <input class="form-check-input" type="checkbox" id="inlineCheckbox6" value="option6">
                  <label class="form-check-label mb-1 h6" for="inlineCheckbox6">Elaborato planimetrico </label>
                  <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a></div>
                  
                 
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 11,20 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 offset-lg-1 mb-5 mb-lg-0">
        <div class="sticky-top">
          <p class="h4 mb-2 text-uppercase">Riepilogo </p>
          <div class=" mb-3">
            <ul class="list-group mb-0">
              <li class="list-group-item d-flex justify-content-between align-items-center"> Visura Catastale per Immobile<span class="badge-pill">€&nbsp;7,00</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center"> Diritti di segreteria Visura Catastale per Immobile<span class="badge-pill">€&nbsp;1,90</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-light"> Subtotale <span class="badge-pill">€&nbsp;8,90</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-light"> Totale IVA <span class="badge-pill">€&nbsp;1,96</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center bg-dark text-white"> <strong>Totale Ordine</strong> <span class="badge-pill"><strong>€&nbsp;10,86</strong></span> </li>
            </ul>
          </div>
          <div class="d-grid gap-2"><a class="btn btn-primary" href="termina-acquisto.php">TERMINA ACQUISTO </a> </div>
        </div>
      </div>
    </div>
  </div>
</main>
<?php require_once('includes/inc-footer.php'); ?>
</body>
</html>
