<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Ufficio Catastale</title>
<?php require_once('includes/inc-css.php'); ?>
</head>

<body>
<?php require_once('includes/inc-header.php'); ?>
<main id="content" role="main">
  <?php require_once('includes/inc-breadcrumbs.php'); ?>
  <div class="container mt-5 content-space-b-1">
    <div class="row mb-5">
      <div class="col-lg-8">
        <h1 class="mb-2 h3 ">Visura Catastale per Immobili </h1>
        <ul class="list-inline mb-3">
          <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
          <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
          <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
          <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
          <li class="list-inline-item ml-2"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
          <li class="list-inline-item ml-2"> <strong style="font-size:18px">4.77 su 5 </strong> </li>
          <li class="list-inline-item ml-2 mr-0"> - </li>
          <li class="list-inline-item ml-2"> di <strong style="font-size:18px">40</strong> valutazioni clienti </li>
        </ul>
        <p class="mb-6">Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile</p>
        <p class="mb-2"><strong>COSTO</strong> <span class="fs-4">€ 7,00 (+ iva)</span></span></p>
        <p class="mb-0"><strong>CONSEGNA</strong> <span class="badge bg-primary ml-2 rounded-pill rounded-pill" style="text-transform:uppercase"> immediata</span></p>
      </div>
      <div class="col-lg-4"><a class="card shadow border card-ghost card-transition-zoom" data-bs-toggle="modal" data-bs-target="#exampleModalCenter" aria-label="Vai al Dettaglio">
            <div class="card-transition-zoom-item  ">
          
              <picture>
                <source srcset="assets/img/demo-visura-small.webp" type="image/webp">
                <source srcset="assets/img/demo-visura-small.png" type="image/png" class="img-fluid card-img rounded lazyload" width="580" height="480" alt="INSERIRE ALT">
                <img src="assets/img/demo-visura-small.png" alt="INSERIRE ALT" class="img-fluid card-img rounded lazyload" width="580" height="480"> </picture>
              
            </div>

            

            
          </a>
          <small>VEDI ESEMPIO</small>
        </div>
    </div>
    <div class="row">
      <div class="col-lg-8">
        <p class="h4 mb-0 text-uppercase"><strong>OPZIONI DISPONIBILI</strong> </p>
        <div class="card bg-light mb-6">
          <div class="list-group p-3 bg-light">
            <label class="list-group-item border-0 bg-light">
            <input class="form-check-input me-1 " type="checkbox" value="">
            <a  data-bs-toggle="collapse" href="#collapse1" role="button" aria-expanded="false" aria-controls="collapse1" class="text-dark"> Stampa e invio per raccomandata urgente <strong>(+ € 7,80)</strong> </a>
            <div class="collapse" id="collapse1">
              <div class="card card-body">
                <div class="row">
                  <div class="col-lg-6 mb-3">
                    <div class="form-group">
                      <label for="destinatario_nome" >Nome*</label>
                      <input type="text" class="form-control form-control-sm " name="destinatario_nome" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-6 mb-3">
                    <div class="form-group">
                      <label for="destinatario_cognome" >Cognome*</label>
                      <input required="" type="text" class="form-control form-control-sm " name="destinatario_cognome" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-12 mb-3">
                    <div class="form-group">
                      <label for="destinatario_co" >Presso (c/o)</label>
                      <input type="text" class="form-control form-control-sm " name="destinatario_co" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-3 mb-3">
                    <div class="form-group">
                      <label for="destinatario_cap" >Cap*</label>
                      <input type="text" required="" class="form-control form-control-sm " name="destinatario_cap" placeholder="Cap" value="">
                    </div>
                  </div>
                  <div class="col-lg-9 mb-3">
                    <div class="form-group">
                      <label for="" >Comune</label>
                      <select class="form-select-sm form-select" name="destinatario_comune">
                        <option value="">-- Seleziona il Comune --</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-12 mb-3">
                    <div class="form-group">
                      <label for="" >Provincia</label>
                      <select class="form-select-sm form-select" name="destinatario_provincia">
                        <option value="">-- Seleziona la Provincia --</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-3 mb-3">
                    <div class="form-group">
                      <label for="" >Via/P.zza*</label>
                      <select required="" class="form-select-sm form-select" id="destinatario_dug" name="destinatario_dug" placeholder=" ">
                        <option value="Borgo">Borgo</option>
                        <option value="Campo">Campo</option>
                        <option value="CDA">Contrada</option>
                        <option value="Corso">Corso</option>
                        <option value="CRO">Crocevia</option>
                        <option value="FRZ">Frazione</option>
                        <option value="GAL">Galleria</option>
                        <option value="Largo">Largo</option>
                        <option value="LOC">Località</option>
                        <option value="PGA">Piaggia</option>
                        <option value="PZA">Piazza</option>
                        <option value="PLE">Piazzale</option>
                        <option value="PZL">Piazzale</option>
                        <option value="PTA">Piazzetta</option>
                        <option value="Rione">Rione</option>
                        <option value="SLT">Salita</option>
                        <option value="SZO">Spiazzo</option>
                        <option value="STR">Strada</option>
                        <option value="SST">Strada Statale</option>
                        <option value="TRV">Traversa</option>
                        <option selected="" value="Via">Via</option>
                        <option value="Viale">Viale</option>
                        <option value="VLO">Vicolo</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-7 mb-3">
                    <div class="form-group">
                      <label for="destinatario_indirizzo" >Indirizzo*</label>
                      <input required="" type="text" class="form-control form-control-sm " id="destinatario_indirizzo" name="destinatario_indirizzo" placeholder=" " value="">
                    </div>
                  </div>
                  <div class="col-lg-2 mb-3">
                    <div class="form-group">
                      <label for="destinatario_civico" >Civico*</label>
                      <input required="" type="text" class="form-control form-control-sm " id="destinatario_civico" name="destinatario_civico" placeholder=" " maxlength="5" value="">
                    </div>
                  </div>
                </div>
              </div>
            </div>
            </label>
            <label class="list-group-item border-0 bg-light">
            <input class="form-check-input me-1" type="checkbox" value="">
            <a  data-bs-toggle="collapse" href="#collapse2" role="button" aria-expanded="false" aria-controls="collapse2" class="text-dark">Avviso SMS a visura disponibile <strong>(+ € 0,50)</strong> </a>
            <div class="collapse " id="collapse2">
              <div class="card card-body">
                <div class="input-group mb-0"> <span class="input-group-text bg-light" id="basic-addon1">+39</span>
                  <input type="number" class="form-control form-control-sm" placeholder="Inserisci il tuo cellulare" aria-label="cellulare" aria-describedby="basic-addon1">
                </div>
              </div>
            </div>
            </label>
            <label class="list-group-item border-0 bg-light">
              <input class="form-check-input me-1" type="checkbox" value="">
              Urgenza <strong>(+ € 5,00)</strong> </label>
          </div>
        </div>
        <div class="row justify-content-between ">
          <div class="col-auto">
            <p class="h4 mb-0 text-uppercase"><strong>PRODOTTI  DISPONIBILI</strong> </p>
          </div>
          <div class="col-auto">
            <div class="form-check form-check-inline">
              <input type="radio" id="formInlineRadio1" class="form-check-input indeterminate-checkbox" checked name="formInlineRadio">
              <label class="form-check-label  text-uppercase" for="formInlineRadio1">Fabbricato</label>
            </div>
            <div class="form-check form-check-inline">
              <input type="radio" id="formInlineRadio2" class="form-check-input "  name="formInlineRadio">
              <label class="form-check-label text-uppercase" for="formInlineRadio2">Terreno</label>
            </div>
          </div>
        </div>
        <div class="row mb-5">
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox1" value="option1">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox1">Visura Catastale per Immobile</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 7,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox2" value="option2">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox2">Planimetria Catastale</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 12,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox3" value="option3">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox3">Visura Ipotecaria per Immobile</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 21,20 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
        </div>
        <div class="row mb-6">
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox4" value="option4">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox4">Visura Catastale Storica Persona Fisica</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 7,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> 2 ore</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox5" value="option5">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox5">Visura Catastale Storica Persona Giuridica</label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a> </div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 7,00 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> 24 ore</span></p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 mb-4 mb-lg-0">
            <div class="card shadow card-pinned h-100">
              <div class="card-body p-4">
                <div class="mb-3">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="inlineCheckbox6" value="option6">
                    <label class="form-check-label mb-1 h6" for="inlineCheckbox6">Elaborato planimetrico </label>
                    <a  data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Ottieni in pochi secondi l'elenco di tutti gli intestatari e i dati identificativi e reddituali di un immobile con la Visura Catastale Immobile"> <i class="bi bi-info-circle-fill"></i></a></div>
                </div>
                <div class="d-flex mb-1">
                  <div class="flex-shrink-0 fs-5 text-dark"> € 11,20 + iva</div>
                </div>
                <p style="font-size: 11px;text-transform:uppercase" class="mb-0">Consegna <span class="badge bg-primary ml-2 rounded-pill" style="text-transform:uppercase"> immediata</span></p>
              </div>
            </div>
          </div>
        </div>
        <div class="text-center">
          <ul class="nav nav-segment nav-pills mb-3 bg-white p-0" role="tablist">
            <li class="nav-item"> <a class="nav-link active" id="nav-one-eg1-tab" href="#nav-one-eg1" data-bs-toggle="pill" data-bs-target="#nav-one-eg1" role="tab" aria-controls="nav-one-eg1" aria-selected="true" style="font-size: 16px;">DESCRIZIONE </a> </li>
            <li class="nav-item"> <a class="nav-link" id="nav-two-eg1-tab" href="#nav-two-eg1" data-bs-toggle="pill" data-bs-target="#nav-two-eg1" role="tab" aria-controls="nav-two-eg1" aria-selected="false" style="font-size: 16px;">FAQ </a> </li>
            <li class="nav-item"> <a class="nav-link" id="nav-three-eg1-tab" href="#nav-three-eg1" data-bs-toggle="pill" data-bs-target="#nav-three-eg1" role="tab" aria-controls="nav-three-eg1" aria-selected="false" style="font-size: 16px;">RECENSIONI </a> </li>
          </ul>
        </div>
        
        <!-- Tab Content -->
        <div class="tab-content">
          <div class="tab-pane fade show active" id="nav-one-eg1" role="tabpanel" aria-labelledby="nav-one-eg1-tab">
            <div class="card ">
              <div class="card-body">
                <p><span >La visura catastale per immobile è un documento digitale rilasciato dall’Agenzia del Territorio (Catasto) che permette di ottenere informazioni su un determinato bene immobile (terreno o fabbricato) .</span></p>
                <p><span >All’interno della visura catastale immobile su terreni sono inclusi questi dati:</span></p>
                <ul>
                  <li ><span >Provincia e Comune</span></li>
                  <li ><span >Identificativi immobile: Foglio, Particella ed eventuale Subalterno</span></li>
                  <li ><span >Dati di classamento come classe, superficie, consistenza.</span></li>
                  <li ><span >Dati reddittuali</span></li>
                  <li ><span >Eventuali Annotazioni</span></li>
                  <li ><span >Dati anagrafici delle persone, fisiche o giuridiche, con diritti e oneri sulla proprietà.</span></li>
                </ul>
                <p><span >Per fare la richiesta di una visura catastale per immobile è necessario conoscere una delle seguenti <strong>informazioni</strong>:&nbsp;&nbsp;</span></p>
                <ul>
                  <li ><span ><strong>Tipo Catasto</strong> (Fabbricato o Terreno)</span></li>
                  <li ><span ><strong>Identificativo catastale dell’immobile</strong>, cioè la particella catastale o l'unità immobiliare</span></li>
                  <li ><strong>Provincia e Comune</strong></li>
                </ul>
                Le informazioni catastali sono pubbliche e chiunque, anche non intestatario dell'immobile, può farne richiesta.<br>
                <br>
                <p><span >La visura catastale online non è disponibile per le provincie di Trento e Bolzano perché gestiti dalle rispettive Province autonome.</span></p>
              </div>
            </div>
          </div>
          <div class="tab-pane fade" id="nav-two-eg1" role="tabpanel" aria-labelledby="nav-two-eg1-tab">
            <div class="accordion" id="accordionExample">
              <div class="accordion-item">
                <div class="accordion-header" id="headingOne"> <a class="accordion-button collapsed" role="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne"> Come richiedere la Visura Catastale? </a> </div>
                <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p><span >Per richiedere la Visura Catastale (Ordinaria o Storica):</span></p>
                    <ul>
                      <li ><span ><strong>Seleziona la visura</strong>&nbsp;di tuo interesse</span></li>
                      <li ><span ><strong>Inserisci i dati</strong>&nbsp;(Ragione Sociale o P.IVA/Codice Fiscale o dati catastali per la visura immobiliare) all'interno del form</span></li>
                      <li ><strong>Verifica&nbsp;</strong>che l'azienda sia effettivamente quella che cerchi, altrimenti effettua una nuova ricerca</li>
                      <li ><span ><strong>Compila il form</strong>&nbsp;con i dati di fatturazione e seleziona il metodo di pagamento</span></li>
                      <li ><strong>Completa il pagamento</strong></li>
                    </ul>
                    <p>Dopo pochi secondi riceverai un’<strong>email</strong>&nbsp;per scaricare la visura richiesta.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <div class="accordion-header" id="headingTwo"> <a class="accordion-button collapsed" role="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo"> Come avviene la consegna della Visura Catastale? </a> </div>
                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                  <div class="accordion-body"> Una volta effettuato il pagamento, al richiedente viene inviata pochi secondi dopo un’e-mail che contiene il link alla Visura Catastale, già pronta per essere scaricata. </div>
                </div>
              </div>
              <div class="accordion-item">
                <div class="accordion-header" id="headingThree"> <a class="accordion-button collapsed" role="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree"> Che validità ha la Visura Catastale? </a> </div>
                <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                  <div class="accordion-body"> I tempi di consegna della Visura Catastale sono di pochi secondi. </div>
                </div>
              </div>
              <div class="accordion-item">
                <div class="accordion-header" id="headingFour"> <a class="accordion-button collapsed" role="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour"> Che validità ha la Visura Catastale? </a> </div>
                <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                  <div class="accordion-body"> I tempi di consegna della Visura Catastale sono di pochi secondi. </div>
                </div>
              </div>
              <div class="accordion-item">
                <div class="accordion-header" id="headingFive"> <a class="accordion-button collapsed" role="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive"> Quali sono le differenze tra la Visura Catastale e la Visura Ipotecaria? </a> </div>
                <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p>La Visura Catastale è un documento prodotto dagli Uffici del Catasto, richiesto soprattutto a fini fiscali: nello specifico la visura catastale per immobile indica l’ubicazione di un immobile e di tutti i dati relativi ad esso (come foglio mappale, particella, categoria, consistenza, rendita etc.) e quella per soggetto contiene i dati di tutti gli immobili di una singola provincia italiana o Conservatoria intestati a una persona fisica o giuridica.</p>
                    <p>La Visura Ipocatastale o Ipotecaria, invece, viene prodotta dalla Conservatoria dei registri immobiliari o dal notaio e contiene dati relativi a&nbsp;ipoteche, locazioni, compravendite, donazioni, passaggi di proprietà. Inoltre&nbsp;la visura ipotecaria serve a reperire informazioni specifiche che possono essere utilizzate anche in procedure giudiziarie, poiché hanno&nbsp;valore di prova&nbsp;(mentre la visura catastale no).</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="tab-pane fade" id="nav-three-eg1" role="tabpanel" aria-labelledby="nav-three-eg1-tab">
            <div class="card ">
              <div class="card-body">
                <h4>Recensioni clienti</h4>
                <ul class="list-inline mb-3">
                  <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
                  <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
                  <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
                  <li class="list-inline-item mx-0"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
                  <li class="list-inline-item ml-2"><img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="15"></li>
                  <li class="list-inline-item ml-2"> <strong style="font-size:18px">4.77 su 5 </strong> </li>
                  <li class="list-inline-item ml-2 mr-0"> - </li>
                  <li class="list-inline-item ml-2"> di <strong style="font-size:18px">40</strong> valutazioni clienti </li>
                </ul>
                <div class="row mb-1">
                  <div class="col-lg-2">5 stelle</div>
                  <div class="col-lg-9">
                    <div class="progress-bar-wrapper">
                      <div class="progress-bar-label">73.07%</div>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: 73.07%" aria-valuenow="73.07 " aria-valuemin="0" aria-valuemax="100"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row mb-1">
                  <div class="col-lg-2">4 stelle</div>
                  <div class="col-lg-9">
                    <div class="progress-bar-wrapper">
                      <div class="progress-bar-label">26.92%</div>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: 26.92%" aria-valuenow="26.92 " aria-valuemin="0" aria-valuemax="100"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row mb-1">
                  <div class="col-lg-2">3 stelle</div>
                  <div class="col-lg-9">
                    <div class="progress-bar-wrapper">
                      <div class="progress-bar-label">0%</div>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: 0%" aria-valuenow="0 " aria-valuemin="0" aria-valuemax="100"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row mb-1">
                  <div class="col-lg-2">2 stelle</div>
                  <div class="col-lg-9">
                    <div class="progress-bar-wrapper">
                      <div class="progress-bar-label">0%</div>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: 0%" aria-valuenow="0 " aria-valuemin="0" aria-valuemax="100"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row mb-1">
                  <div class="col-lg-2">1 stella</div>
                  <div class="col-lg-9">
                    <div class="progress-bar-wrapper">
                      <div class="progress-bar-label">0%</div>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: 0%" aria-valuenow="0 " aria-valuemin="0" aria-valuemax="100"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="form-group  mt-5 mb-3">
                  <label for="exampleFormControlSelect2" class="">Ordina per </label>
                  <select  class="form-select" >
                    <option value="1">Le più recenti</option>
                    <option value="2">Le migliori</option>
                    <option value="3">Le peggiori</option>
                  </select>
                </div>
                <div id="lista_feedback">
                  <hr style="border-bottom: 1px solid rgba(0,0,0,.125);">
                  <div style="margin-bottom: 1rem!important;">
                    <div>
                      <h2 class="h6 mb-0"> Orazio Martini</h2>
                      <div class="mt-2 mb-2"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> </div>
                      <p class=" mb-0"> Dal mio punto di vista un ottimo servizio </p>
                    </div>
                  </div>
                  <hr style="border-bottom: 1px solid rgba(0,0,0,.125);">
                  <div style="margin-bottom: 1rem!important;">
                    <div>
                      <h2 class="h6 mb-0"> Utente anonimo</h2>
                      <div class="mt-2 mb-2"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> </div>
                      <p class=" mb-0"> Visura catastale ottenuta senza difficoltà </p>
                    </div>
                  </div>
                  <hr style="border-bottom: 1px solid rgba(0,0,0,.125);">
                  <div style="margin-bottom: 1rem!important;">
                    <div>
                      <h2 class="h6 mb-0"> Utente anonimo</h2>
                      <div class="mt-2 mb-2"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> </div>
                      <p class=" mb-0"> Approvo, documento ricevuto </p>
                    </div>
                  </div>
                  <hr style="border-bottom: 1px solid rgba(0,0,0,.125);">
                  <div style="margin-bottom: 1rem!important;">
                    <div>
                      <h2 class="h6 mb-0"> Anna Esposto</h2>
                      <div class="mt-2 mb-2"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> </div>
                      <p class=" mb-0"> visura catastale semplice da richiedere </p>
                    </div>
                  </div>
                  <hr style="border-bottom: 1px solid rgba(0,0,0,.125);">
                  <div style="margin-bottom: 1rem!important;">
                    <div>
                      <h2 class="h6 mb-0"> Maurizio Denunzio</h2>
                      <div class="mt-2 mb-2"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> <img src="./assets/svg/illustrations/star.svg" alt="Review rating" width="18"> </div>
                      <p class=" mb-0"> bene </p>
                    </div>
                  </div>
                  <div class="text-center"> <a href="#" class="btn btn-primary text-uppercase" onclick="">Mostra tutte</a> </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 offset-lg-1 mb-5 mb-lg-0">
        <div class="sticky-top">
          <p class="h4 mb-2 text-uppercase">Riepilogo </p>
          <div class=" mb-3">
            <ul class="list-group mb-0">
              <li class="list-group-item d-flex justify-content-between align-items-center"> Visura Catastale per Immobile<span class="badge-pill">€&nbsp;7,00</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center"> Diritti di segreteria Visura Catastale per Immobile<span class="badge-pill">€&nbsp;1,90</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-light"> Subtotale <span class="badge-pill">€&nbsp;8,90</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-light"> Totale IVA <span class="badge-pill">€&nbsp;1,96</span></li>
              <li class="list-group-item d-flex justify-content-between align-items-center bg-dark text-white"> <strong>Totale Ordine</strong> <span class="badge-pill"><strong>€&nbsp;10,86</strong></span> </li>
            </ul>
          </div>
          <div class="d-grid gap-2"><a class="btn btn-primary" href="termina-acquisto.php">TERMINA ACQUISTO </a> </div>
        </div>
      </div>
    </div>
  </div>
</main>
<?php require_once('includes/inc-footer.php'); ?>
</body>
</html>
<div id="exampleModalCenter" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalCenterTitle">Visura Catastale per Immobili</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <picture>
                <source srcset="assets/img/demo-visura-big.webp" type="image/webp">
                <source srcset="assets/img/demo-visura-big.png" type="image/png" class="img-fluid  border lazyload" width="750" height="621" alt="INSERIRE ALT">
                <img src="assets/img/demo-visura-big.png" alt="INSERIRE ALT" class="img-fluid  border lazyload" width="750" height="621"> </picture>
    </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-white" data-bs-dismiss="modal">CHIUDI</button>
     
      </div>
    </div>
  </div>
</div>