<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Ufficio Catastale</title>
<?php require_once('includes/inc-css.php'); ?>
</head>
<body>
<?php require_once('includes/inc-header.php'); ?>
<main id="content" role="main">
  <div class="overflow-hidden">
    <div class="container content-space-1">
      <div class="row">
        <div class="col-lg-6 mb-5">
          <div class="card zi-2 h-100">
            <div class="card-header text-center">
              <h4 class="card-title text-uppercase">Accedi</h4>
              <p class="card-text">Sono già vostro Cliente</p>
            </div>
            <div class="card-body">
              <form class="js-validate need-validate" novalidate="">
                <div class="d-grid mb-3"> <a class="btn btn-white btn-lg" href="#"> <span class="d-flex justify-content-center align-items-center"> <img class="avatar avatar-xss me-2" src="./assets/svg/brands/google-icon.svg" alt="Image Description"> Accedi con Google </span> </a> </div>
                <div class="d-grid"> <a class="btn btn-white btn-lg" href="#"> <span class="d-flex justify-content-center align-items-center"> <img class="avatar avatar-xss me-2" src="./assets/svg/brands/facebook-icon.svg" alt="Image Description"> Accedi con Facebook </span> </a> </div>
                <span class="divider-center my-4 text-dark">OPPURE</span>
                <div class="mb-4">
                  <label class="form-label" for="loginFormEmail">EMAIL</label>
                  <input type="email" class="form-control" name="loginFormEmailName" id="loginFormEmail" placeholder="Email" aria-label="Email" required="">
                  <span class="invalid-feedback">INSERISCI IL TUO INDIRIZZO EMAIL</span> </div>
                <div class="mb-4">
                  <div class="d-flex justify-content-between align-items-center">
                    <label class="form-label" for="loginFormPassword">Password</label>
                    <a href="#" class="form-label-link" data-bs-toggle="modal" data-bs-target="#psw-smarrita" aria-label="Password smarrita">Password smarrita? </a> </div>
                  <div class="input-group input-group-merge">
                    <input type="password" class="js-toggle-password form-control" name="loginFormPasswordName" id="loginFormPassword" placeholder="Password" aria-label="Password" required="" data-hs-toggle-password-options="{
                         &quot;target&quot;: &quot;#loginFormChangePassTarget&quot;,
                         &quot;defaultClass&quot;: &quot;bi-eye-slash&quot;,
                         &quot;showClass&quot;: &quot;bi-eye&quot;,
                         &quot;classChangeTarget&quot;: &quot;#changePassIcon&quot;
                       }">
                    <a id="loginFormChangePassTarget" class="input-group-append input-group-text" href="javascript:;" aria-label="Vedi Password"> <i id="changePassIcon" class="bi-eye-slash"></i> </a> </div>
                  <span class="invalid-feedback">La tua Password non è valida. Prova ancora, grazie!</span> </div>
                <!-- End Form --> 
                
                <!-- Checkbox -->
                <div class="form-check mb-0">
                  <input type="checkbox" class="form-check-input" id="loginFormRememberMeCheck" name="loginFormRememberMeCheck">
                  <label class="form-check-label" for="loginFormRememberMeCheck"> Ricordami</label>
                </div>
                <!-- End Checkbox -->
                
              </form>
            </div>
            <div class="card-footer">
              <div class="d-grid gap-2"> <a href="ar-dashboard.php" class="btn btn-primary btn-lg">LOG IN</a> </div>
            </div>
            <!-- End Card Body --> 
          </div>
        </div>
        <div class="col-lg-6  mb-5">
          <div class="card zi-2 h-100" style="background-color: #E5F2EF"> 
            <div class="card-header text-center">
              <h4 class="card-title  text-uppercase">Registrati</h4>
              <p class="card-text">Registrarsi al portale conviene!</p>
            </div>
            <div class="card-body ">
              <form class="js-validate need-validate" novalidate="">
                <div class="d-grid mb-3"> <a class="btn btn-white btn-lg" href="#"> <span class="d-flex justify-content-center align-items-center"> <img class="avatar avatar-xss me-2" src="assets/svg/brands/google-icon.svg" alt="Image Description"> Registrati con Google </span> </a> </div>
                <div class="d-grid"> <a class="btn btn-white btn-lg" href="#"> <span class="d-flex justify-content-center align-items-center"> <img class="avatar avatar-xss me-2" src="assets/svg/brands/facebook-icon.svg" alt="Image Description"> Registrati con Facebook </span> </a> </div>
                <span class="divider-center my-4 text-dark">OPPURE</span> 

                <div class="mb-4">
                  <label class="form-label" for="loginFormEmail2">EMAIL</label>
                  <input type="email" class="form-control" name="loginFormEmailName" id="loginFormEmail2" placeholder="Email" aria-label="email" required="">
                  <span class="invalid-feedback">INSERISCI IL TUO INDIRIZZO EMAIL</span> </div>
                
                <div class="form-check mb-3">
                  <input type="checkbox" id="formCheck11" class="form-check-input">
                  <label class="form-check-label" for="formCheck11">Dichiaro di aver letto la <a href="#">Privacy Policy</a></label>
                </div>
                <div class="form-check mb-3">
                  <input type="checkbox" id="formCheck12" class="form-check-input">
                  <label class="form-check-label" for="formCheck12">Dichiaro di aver letto le <a href="#">Note Legali</a></label>
                </div>
                
              </form>
            </div>
            <div class="card-footer">
              <div class="d-grid gap-2"> <a class="btn btn-primary btn-lg" href="post-registrazione.php">REGISTRATI</a> </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<?php require_once('includes/inc-footer.php'); ?>
</body>
</html>